//AIM:Computation of N-Point DFT using DIT method.
//Software version Scilab 5.5.2
//OS windows 10
clc;
clear;
// We will compute the DFT of the sequence x(n)={0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15}
//using DIT(Split radix) method for N=16(4*4)
//For understanding,let us write the given data as
//x(0)=0,x(1)=1,x(2)=2,x(3)=3,x(4)=4,x(5)=5,x(6)=6,x(7)=7,x(8)=8,x(9)=9,x(10)=10,x(11)=11,x(12)=12,x(13)=13,x(14)=14,x(15)=15
x0=0;//DIT-FFT so arranging the input in shuffled order
x4=4;//DIT-FFT so arranging the input in shuffled order
x8=8;//DIT-FFT so arranging the input in shuffled order
x12=12;//DIT-FFT so arranging the input in shuffled order
x1=1;//DIT-FFT so arranging the input in shuffled order
x5=5;//DIT-FFT so arranging the input in shuffled order
x9=9;//DIT-FFT so arranging the input in shuffled order
x13=13;//DIT-FFT so arranging the input in shuffled order
x2=2;//DIT-FFT so arranging the input in shuffled order
x6=6;//DIT-FFT so arranging the input in shuffled order
x10=10;//DIT-FFT so arranging the input in shuffled order
x14=14;//DIT-FFT so arranging the input in shuffled order
x3=3;//DIT-FFT so arranging the input in shuffled order
x7=7;//DIT-FFT so arranging the input in shuffled order
x11=11;//DIT-FFT so arranging the input in shuffled order
x15=15;//DIT-FFT so arranging the input in shuffled order

//Computing the Twiddle factors
W0=cos(((2*%pi)/16)*0)-sqrt(-1)*sin(((2*%pi)/16)*0)
W1=cos(((2*%pi)/16)*1)-sqrt(-1)*sin(((2*%pi)/16)*1)
W2=cos(((2*%pi)/16)*2)-sqrt(-1)*sin(((2*%pi)/16)*2)
W3=cos(((2*%pi)/16)*3)-sqrt(-1)*sin(((2*%pi)/16)*3)
W4=cos(((2*%pi)/16)*4)-sqrt(-1)*sin(((2*%pi)/16)*4)
W5=cos(((2*%pi)/16)*5)-sqrt(-1)*sin(((2*%pi)/16)*5)
W6=cos(((2*%pi)/16)*6)-sqrt(-1)*sin(((2*%pi)/16)*6)
W7=cos(((2*%pi)/16)*7)-sqrt(-1)*sin(((2*%pi)/16)*7)
W8=cos(((2*%pi)/16)*8)-sqrt(-1)*sin(((2*%pi)/16)*8)
W9=cos(((2*%pi)/16)*9)-sqrt(-1)*sin(((2*%pi)/16)*9)
W10=cos(((2*%pi)/16)*10)-sqrt(-1)*sin(((2*%pi)/16)*10)
W11=cos(((2*%pi)/16)*11)-sqrt(-1)*sin(((2*%pi)/16)*11)
W12=cos(((2*%pi)/16)*12)-sqrt(-1)*sin(((2*%pi)/16)*12)
W13=cos(((2*%pi)/16)*13)-sqrt(-1)*sin(((2*%pi)/16)*13)
W14=cos(((2*%pi)/16)*14)-sqrt(-1)*sin(((2*%pi)/16)*14)
W15=cos(((2*%pi)/16)*15)-sqrt(-1)*sin(((2*%pi)/16)*15)

//First stage
X0a=x0+x4+x8+x12
X1b=x0+x4*W4+x8*W8+x12*W12; //at line 2; x4, x8 & x12 are to be multiplied by factor W4, W8 and W12 respectively
X2c=x0+x4*W8+x8*1+x12*W8; //at line 3; x4, x8 & x12 are to be multiplied by factor W8, W16=1,and W8 respectively
X3d=x0+x4*W12+x8*W8+x12*W4;// at line 4; x4, x8 & x12 are to be multiplied by factor W12, W8 and W4 respectively
X4e=x1+x5+x9+x13
X5f=x1+x5*W4+x9*W8+x13*W12; //at line 6; x5, x9 & x13 are to be multiplied by factor W4, W8 and W12 respectively
X6g=x1+x5*W8+x9*1+x13*W8; //at line 7; x5, x9 & x13 are to be multiplied by factor W8, W16=1,and W8 respectively
X7h=x1+x5*W12+x9*W8+x13*W4; // at line 8; x5, x9 & x13 are to be multiplied by factor W12, W8 and W4 respectively
X8i=x2+x6+x10+x14
X9j=x2+x6*W4+x10*W8+x14*W12; //at line 10; x6, x10 & x14 are to be multiplied by factor W4, W8 and W12 respectively
X10k=x2+x6*W8+x10*1+x14*W8;  //at line 11; x6, x10 & x14 are to be multiplied by factor W8, W16=1,and W8 respectively
X11m=x2+x6*W12+x10*W8+x14*W4; //at line 12; x6, x10 & x14 are to be multiplied by factor W12, W8 and W4 respectively
X12n=x3+x7+x11+x15;
X13o=x3+x7*W4+x11*W8+x15*W12; //at line 14; x7, x11 & x15 are to be multiplied by factor W4, W8 and W12 respectively
X14p=x3+x7*W8+x11*1+x15*W8; //at line 15; x7, x11 & x1 are to be multiplied by factor W8, W16=1,and W8 respectively
X15q=x3+x7*W12+x11*W8+x15*W4; //at line 16; x7, x11 & x15 are to be multiplied by factor W12, W8 and W4 respectively

//Second stage
X0=X0a+X4e+X8i+X12n
X1=X1b+X5f*W1+X9j*W2+X13o*W3; // at line 2; X5f, x9j and X13o are to be multiplied by factor W1 W2 and W3 respectively
X2=X2c+X6g*W2+X10k*W4+X14p*W6; //at line 3; X6g, X10k and X14p are to be multiplied by factor W2, W4 and W6 respectively
X3=X3d+X7h*W3+X11m*W6+X15q*W9; //at line 4; X7h, X11m, and X15q are to be multipled by factor W3, W6 and W9 respectively
X4=X0a+X4e*W4+X8i*W8+X12n*W12; // at line 5; X4e, X8i and X12n are to be multiplied by factor W4, W8 and W12 respectively
X5=X1b+X5f*W5+X9j*W10+X13o*W15; //at line 6; X5f, x9j and X13o are to be multiplied by factor W5 W10 and W15 respectively
X6=X2c+X6g*W6+X10k*W12+X14p*W2; //at line 7; X6g, X10k and X14p are to be multiplied by factor W6, W12 and W2 respectively
X7=X3d+X7h*W7+X11m*W14+X15q*W5; //at line 8;X7h, X11m, and X15q are to be multipled by factor W7, W14 and W5 respectively
X8=X0a+X4e*W8+X8i*1+X12n*W8; // at line 9;X4e, X8i and X12n are to be multiplied by factor W8, 1 and W8 respectively
X9=X1b+X5f*W9+X9j*W2+X13o*W11; // at line 10; X5f, x9j and X13o are to be multiplied by factor W9 W2 and W11 respectively
X10=X2c+X6g*W10+X10k*W4+X14p*W14; //at line 11; X6g, X10k and X14p are to be multiplied by factor W10 W4 & W14 respectively
X11=X3d+X7h*W11+X11m*W6+X15q*W1; //at line 12;X7h, X11m, and X15q are to be multipled by factor W11, W6 and W1 respectively
X12=X0a+X4e*W12+X8i*W8+X12n*W4; //at line 13;X4e, X8i and X12n are to be multiplied by factor W12, W8 and W4 respectively
X13=X1b+X5f*W13+X9j*W10+X13o*W7; //at line 14; X5f, x9j and X13o are to be multiplied by factor W13 W10 and W7 respectively
X14=X2c+X6g*W14+X10k*W12+X14p*W10; //at line 15;X6g, X10k and X14p are to be multiplied by factor W14 W12 and W10 respectively
X15=X3d+X7h*W15+X11m*W14+X15q*W13; //at line 16;X7h,X11m & X15q are to be multipled by factor W15,W14 & W13 respectively
disp(X0)
disp(X1)
disp(X2)
disp(X3)
disp(X4)
disp(X5)
disp(X6)
disp(X7)
disp(X8)
disp(X9)
disp(X10)
disp(X11)
disp(X12)
disp(X13)
disp(X14)
disp(X15)
disp({X0,X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15})

//Expected output:X(k)={120,-8+ 40.218716i,-8+19.313708i,-8+11.972846i,-8+8i,-8+5.3454291i,-8+3.3137085i, //-8+1.5912989i,-8-7.838D-15i,-8-1.5912989i,-8-3.3137085i,-8-5.3454291i,-8-8i,-8-11.972846i,-8-19.313708i,
//-8-40.218716i} 





